Option Explicit

Dim WshShell
Dim WshEnv
Dim objFile
Dim objFso
Dim ObjDoc
Dim bRet
'Dim testtype

Dim EnvVerdict
Dim EnvSerial
Dim EnvPath
Dim EnvName
Dim EnvResults_Fail
Const LABEL_TEMPLATE_PATH_PASS = "MyLabelPass.lbx"
Const LABEL_TEMPLATE_PATH_FAIL = "MyLabelFail.lbx"

Set WshShell = WScript.CreateObject("WScript.Shell")
Set WshEnv = WshShell.Environment("Process")
Set objFso = CreateObject("Scripting.FileSystemObject") 

EnvResults_Fail = WshEnv("Results_Fail")
REM collecting environment variables from the QC test
EnvSerial = WshEnv("Cfg_SerialNumber")
If EnvSerial = Empty Then
	MsgBox "Environment variable ''Cfg_SerialNumber'' is empty. Please specify the SN."
End If

EnvVerdict = WshEnv("Ctrl_OverallVerdict")
If EnvVerdict = "-1" Then
	MsgBox "Environment variable ''Ctrl_OverallVerdict'' is void. Please set the limits."
	EnvVerdict = "Empty"
	
REM triggering the lable printing for passed test 	
ElseIf EnvVerdict = "1" Then
	PrintLabel LABEL_TEMPLATE_PATH_PASS 

REM triggering the lable printing for failed test 	
ElseIf EnvVerdict = "0" Then
	PrintLabel LABEL_TEMPLATE_PATH_FAIL 
End If

REM adjusting the label layout. This sample is provided within the program package of the Brother printer.
	'*******************************************************************
	'	Print Module
	'******************************************************************* 
Sub PrintLabel(LabelTemplatePath)
	Dim ObjDoc
	Dim bRet
	
	Set ObjDoc = CreateObject("bpac.Document")
	bRet = ObjDoc.Open(LabelTemplatePath)
	If bRet <> False Then
	    EnvPath = WshEnv("Cfg_DatabasePath") REM collecting environment variable "Cfg_DatabasePath" from the QC test and getting the test name
        Set objFile = objFso.GetFile(EnvPath)
		'Wscript.Echo "path:" & EnvPath
        EnvName = objFso.GetBaseName(objFile)
	    ObjDoc.GetObject("objProduct").Text = EnvName
		'Wscript.Echo "name:" & EnvName
        'testtype = VarType(EnvName)
        'Wscript.Echo "type:" & testtype
		If EnvVerdict = "1" Then
		   ObjDoc.GetObject("objInfo").Text = "QC Test: PASS"
		end if
		If EnvVerdict = "0" Then
			ObjDoc.GetObject("objFailedInfo").Text = EnvResults_Fail
			ObjDoc.GetObject("objVerdict").Text = "FAIL:"
		end if
		If EnvSerial <> Empty Then
		   ObjDoc.SetBarcodeData 0, EnvSerial
		   ObjDoc.StartPrint "", 0
		   ObjDoc.PrintOut 1, 0
		   ObjDoc.EndPrint
		   ObjDoc.Close
		end if
	End If
	Set ObjDoc = Nothing
End Sub

Set WshEnv = Nothing
Set WshShell = Nothing
set objFile = Nothing
set objFso = Nothing
